/* nag_wav.h
 *
 * Function prototypes for wavelet transforms
 *
 */
///  *	ML 11/10/2005 ORGONAG_DLL													*
/// ML 11/10/2005 ORGONAG_DLL
/// ML 10/23/2006 NEW_NAG_WAVELET_UPDATE
//#include <math.h>

/// ML 11/10/2005 ORGONAG_DLL

//#include <nag8\nag_wav_types.h>
//#include <nag8\nag_wav_aux.h>

#ifdef __AFX_H__	   //VC
#include "nag_wav_types.h"
#include "nag_wav_aux.h"
/// ML 10/23/2006 NEW_NAG_WAVELET_UPDATE
#define		ONAG_NAG_WAV_FUN		extern	void
#include "nag_wav_fun.h"
/// end NEW_NAG_WAVELET_UPDATE
#else // !__AFX_H__

#include <nag8\nag_wav_types.h>
#include <nag8\nag_wav_aux.h>
/// ML 10/23/2006 NEW_NAG_WAVELET_UPDATE
#define		ONAG_NAG_WAV_FUN		NAG_DLL_EXPIMP	void	NAG_CALL
#include <nag8\nag_wav_fun.h>
/// end NEW_NAG_WAVELET_UPDATE

#endif // !__AFX_H__

/// end ORGONAG_DLL


#ifdef __cplusplus
extern "C"
{
#endif


/// ML 10/12/2005

/// ML 11/10/2005 ORGONAG_DLL
#ifdef __AFX_H__	   //VC
/// ML 10/23/2006 NEW_NAG_WAVELET_UPDATE
//#define		ONAG_NAG_WAV_FUN		extern	void
/// end NEW_NAG_WAVELET_UPDATE
#else // !__AFX_H__
/// end ORGONAG_DLL

#pragma	dll(ONAG_ex.dll)
/// ML 10/23/2006 NEW_NAG_WAVELET_UPDATE
//#define		ONAG_NAG_WAV_FUN		NAG_DLL_EXPIMP	void	NAG_CALL
/// end NEW_NAG_WAVELET_UPDATE
/// ML 11/10/2005 ORGONAG_DLL
#endif // !__AFX_H__

/// end ORGONAG_DLL

/// end ML 10/12/2005


#define SQRT_HALF (0.5)*sqrt(2.0);
#define SQRT_2 sqrt(2.0);

  /* Structure used by wavelet functions */
  typedef struct{
    Nag_WavType wavname;
    /* Filter lengths */
    Integer nld;
    Integer nhd;
    Integer nlr;
    Integer nhr;
    /* Shifts for biorthogonal filters */
    Integer ldsh;
    Integer hdsh;
    Integer lrsh;
    Integer hrsh;
    /* Filter coefficients */
    double *ld;     /* Low pass decomposition */
    double *hd;     /* High pass decomposition */
    double *lr;     /* Low pass reconstruction */
    double *hr;     /* High pass reconstruction */
  } Nag_WavFilt;

/*
 * 1D Continuous Real Wavelet Transform (CWT) 
 *
 */

ONAG_NAG_WAV_FUN nag_cwt_real(Nag_WavType wavname,
			 Integer wavparam, Integer n, const double x[],
                         Integer ns, const Integer scales[], double coefs[], 
		         NagError *fail);

/*
 * Filter Initialisation
 *
 */

ONAG_NAG_WAV_FUN nag_wavfilter(Nag_WavType wavname,
                   Nag_WavFilt *filter, NagError *fail);
/*
 * Filter free
 *
 */

ONAG_NAG_WAV_FUN nag_free_wavfilter(Nag_WavFilt *filter);

/*
 * 1D Discrete Wavelet Transform (DWT)
 *
 */

ONAG_NAG_WAV_FUN nag_dwt(Nag_WavModeType mode, Integer n,
		     const double x[], Nag_WavFilt *filter, Integer nc, 
		     double ca[], double cd[], NagError *fail);

/* 
 * 1D Inverse Discrete Wavelet Transform (IDWT)
 *
 */

ONAG_NAG_WAV_FUN nag_idwt(Nag_WavModeType mode,
					     Integer nc, const double ca[], 
					     const double cd[],
					     Nag_WavFilt *filter, Integer n,
					     double y[], NagError *fail);

/*
 * 2D Discrete Wavelet Transform (DWT2)
 *
 */

ONAG_NAG_WAV_FUN nag_dwt2(Nag_WavModeType mode, Integer m,
					     Integer n, const double a[],
					     Nag_WavFilt *filter, Integer mc,
					     Integer nc, double ca[],
					     double ch[], double cv[],
					     double cd[], NagError *fail);

/*
 * 2D Inverse Discrete Wavelet Transform (IDWT2)
 *
 */

ONAG_NAG_WAV_FUN nag_idwt2(Nag_WavModeType mode, Integer mc,
					      Integer nc, const double ca[],
					      const double ch[], const double cv[],
					      const double cd[], Nag_WavFilt *filter,
					      double b[], NagError *fail);

///Sandy 2006-11-15 MOVE_FROM_NAG_WAV_FUN_H_FOR_USING					 
/*
 * 1D Continuous Wavelet Functions 
 *
 */					      
ONAG_NAG_WAV_FUN nag_morlet(Integer wavenum, Integer n,
		   double x[], double psi[], NagError *fail);

ONAG_NAG_WAV_FUN nag_dgauss(Integer m, Integer n,
                       double x[], double psi[], NagError *fail);

ONAG_NAG_WAV_FUN nag_mexhat(Integer n, double x[],
                       double psi[], NagError *fail);
//end of MOVE_FROM_NAG_WAV_FUN_H_FOR_USING                       


#ifdef __cplusplus
}
#endif
